/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleEvent;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleListener;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerParms;
import com.ibm.hwmca.fw.util.TimerTaskControl;
import com.ibm.hwmca.fw.util.TimerTaskExecutionControl;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;

public final class HMCTimer {
    private static final String TRACE_MASKT = "XH-TIMET";
    private static final String TRACE_MASKF = "XH-TIMEF";
    private static final String TRACE_MASKD = "XH-TIMED";
    private static HMCTimer theSingleTimer = null;
    private static final int TIMER_THREAD_LIMIT = 25;
    private String name = null;
    private boolean terminate = false;
    private HMCTaskQueue queue = new HMCTaskQueue();
    private HMCTimerThread timerThread = null;
    private int threadCnt = 0;
    private int currentActiveTimerThreads = 0;

    public static synchronized HMCTimer getHMCTimer() {
        if (theSingleTimer == null) {
            theSingleTimer = new HMCTimer("Common HMC-Timer");
        }
        return theSingleTimer;
    }

    private HMCTimer(String name) {
        this.name = name;
        this.timerThread = new HMCTimerThread(name + "-service:" + this.threadCnt++);
        this.timerThread.setDaemon(true);
        ++this.currentActiveTimerThreads;
        this.timerThread.start();
        HMCTimerGuardThread watcherThread = new HMCTimerGuardThread(name + "-guard");
        watcherThread.setDaemon(true);
        watcherThread.start();
        TimeManager.getTimeManager().addTimeChangedOnConsoleListener(this.queue);
    }

    protected void finalize() {
        this.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTaskControl scheduleTask(TimerParms parms) {
        ProxiedTimerTask pTask = new ProxiedTimerTask(parms);
        HMCTaskQueue hMCTaskQueue = this.queue;
        synchronized (hMCTaskQueue) {
            this.queue.add(pTask);
            this.queue.notifyAll();
        }
        return pTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", terminate()");
        HMCTaskQueue hMCTaskQueue = this.queue;
        synchronized (hMCTaskQueue) {
            this.terminate = true;
            this.queue.notifyAll();
        }
    }

    public TimerTaskControl schedule(HMCTimerTask task, long delay) {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", schedule(" + task + ", " + delay + ")");
        TimerParms tp = new TimerParms(delay);
        tp.setTask(task);
        return this.scheduleTask(tp);
    }

    public TimerTaskControl schedule(HMCTimerTask task, Date time) {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", schedule(" + task + ", " + time + ")");
        TimerParms tp = new TimerParms(time);
        tp.setTask(task);
        return this.scheduleTask(tp);
    }

    public TimerTaskControl schedule(HMCTimerTask task, TimerParms parms) {
        Trace.trace(TRACE_MASKF, "Timer: " + this.name + ", schedule(" + task + ", " + parms + ")");
        parms.setTask(task);
        return this.scheduleTask(parms);
    }

    class HMCTimerThread
    extends Thread {
        boolean timerThread = true;
        ProxiedTimerTask runningTask = null;

        HMCTimerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setTimerThread(boolean value) {
            HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
            synchronized (hMCTaskQueue) {
                this.timerThread = value;
                HMCTimer.this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') begins running.");
            try {
                while (!HMCTimer.this.terminate && this.timerThread) {
                    HMCTaskQueue hMCTaskQueue;
                    Object var7_5;
                    ProxiedTimerTask pTask = null;
                    try {
                        HMCTaskQueue hMCTaskQueue2 = HMCTimer.this.queue;
                        synchronized (hMCTaskQueue2) {
                            while (HMCTimer.this.queue.isEmpty() && !HMCTimer.this.terminate && this.timerThread) {
                                HMCTimer.this.queue.wait();
                            }
                            if (!HMCTimer.this.terminate && this.timerThread) {
                                pTask = HMCTimer.this.queue.next();
                                if (pTask.canceled) {
                                    HMCTimer.this.queue.remove();
                                } else {
                                    long currentTime = System.currentTimeMillis();
                                    if (pTask.nextExecutionTime <= currentTime) {
                                        pTask.scheduledExecutionTime = pTask.nextExecutionTime;
                                        if (pTask.period == 0L) {
                                            HMCTimer.this.queue.remove();
                                        } else {
                                            HMCTimer.this.queue.reschedule(pTask.reschedule(currentTime));
                                        }
                                        if (!pTask.active) {
                                            this.runningTask = pTask;
                                            pTask.active = true;
                                            HMCTimer.this.queue.notifyAll();
                                        }
                                    } else {
                                        HMCTimer.this.queue.wait(pTask.nextExecutionTime - currentTime);
                                    }
                                }
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.runningTask == null) continue;
                    try {
                        this.runningTask.run();
                        var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        var7_5 = null;
                        hMCTaskQueue = HMCTimer.this.queue;
                        synchronized (hMCTaskQueue) {
                            this.runningTask.active = false;
                            this.runningTask = null;
                            HMCTimer.this.queue.notifyAll();
                            throw throwable;
                        }
                    }
                    hMCTaskQueue = HMCTimer.this.queue;
                    synchronized (hMCTaskQueue) {
                        this.runningTask.active = false;
                        this.runningTask = null;
                        HMCTimer.this.queue.notifyAll();
                    }
                }
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
                synchronized (hMCTaskQueue) {
                    HMCTimer.this.currentActiveTimerThreads--;
                    HMCTimer.this.queue.notifyAll();
                }
                Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') ends.");
                throw throwable;
            }
            HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
            synchronized (hMCTaskQueue) {
                HMCTimer.this.currentActiveTimerThreads--;
                HMCTimer.this.queue.notifyAll();
            }
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') ends.");
        }
    }

    class HMCTimerGuardThread
    extends Thread {
        HMCTimerGuardThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') begins running.");
            while (!HMCTimer.this.terminate) {
                HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
                synchronized (hMCTaskQueue) {
                    while ((HMCTimer.this.currentActiveTimerThreads >= 25 || HMCTimer.this.queue.isEmpty() || ((HMCTimer)HMCTimer.this).timerThread.runningTask == null) && !HMCTimer.this.terminate) {
                        if (HMCTimer.this.currentActiveTimerThreads >= 25) {
                            Trace.trace(HMCTimer.TRACE_MASKF, "Warning: HMC-Timer ('" + Thread.currentThread().getName() + "') is at the maximum allowable thread count (" + 25 + ").");
                        }
                        try {
                            HMCTimer.this.queue.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                    if (!HMCTimer.this.terminate) {
                        ProxiedTimerTask pTask = HMCTimer.this.queue.next();
                        long currentTime = System.currentTimeMillis();
                        if (pTask.nextExecutionTime <= currentTime) {
                            if (pTask.active) {
                                HMCTimer.this.queue.reschedule(pTask.reschedule(currentTime));
                                continue;
                            }
                            HMCTimer.this.timerThread.setTimerThread(false);
                            HMCTimer.this.timerThread = new HMCTimerThread(HMCTimer.this.name + "-service:" + HMCTimer.this.threadCnt++);
                            HMCTimer.this.timerThread.setDaemon(true);
                            HMCTimer.this.currentActiveTimerThreads++;
                            HMCTimer.this.timerThread.start();
                        } else {
                            try {
                                HMCTimer.this.queue.wait(pTask.nextExecutionTime - currentTime);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer thread ('" + Thread.currentThread().getName() + "') ends.");
        }
    }

    static class HMCTaskQueue
    implements TimeChangedOnConsoleListener {
        private ProxiedTimerTask[] queue = new ProxiedTimerTask[128];
        private int size = 0;

        HMCTaskQueue() {
        }

        void add(ProxiedTimerTask task) {
            if (++this.size == this.queue.length) {
                ProxiedTimerTask[] newQueue = new ProxiedTimerTask[2 * this.queue.length];
                System.arraycopy(this.queue, 0, newQueue, 0, this.size);
                this.queue = newQueue;
            }
            this.queue[this.size] = task;
            this.fixUp(this.size);
        }

        ProxiedTimerTask next() {
            return this.queue[1];
        }

        void remove() {
            this.queue[1] = this.queue[this.size];
            this.queue[this.size--] = null;
            this.fixDown(1);
        }

        void reschedule(long newTime) {
            this.queue[1].nextExecutionTime = newTime;
            this.fixDown(1);
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        void clear() {
            for (int i = 1; i <= this.size; ++i) {
                this.queue[i] = null;
            }
            this.size = 0;
        }

        public synchronized void timeChangedOnConsole(TimeChangedOnConsoleEvent event) {
            ProxiedTimerTask[] oldQueue = this.queue;
            this.queue = new ProxiedTimerTask[this.queue.length];
            for (int i = 1; i <= this.size; ++i) {
                oldQueue[i].timeChanged(event);
                this.add(oldQueue[i]);
            }
        }

        private void fixUp(int k) {
            while (k > 1) {
                int j = k >> 1;
                if (this.queue[j].nextExecutionTime <= this.queue[k].nextExecutionTime) break;
                ProxiedTimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
            }
        }

        private void fixDown(int k) {
            int j;
            while ((j = k << 1) <= this.size) {
                if (j < this.size && this.queue[j].nextExecutionTime > this.queue[j + 1].nextExecutionTime) {
                    ++j;
                }
                if (this.queue[k].nextExecutionTime <= this.queue[j].nextExecutionTime) break;
                ProxiedTimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
            }
        }
    }

    class ProxiedTimerTask
    implements TimerTaskExecutionControl {
        HMCTimerTask task;
        boolean active;
        long nextExecutionTime;
        long scheduledExecutionTime;
        long period = 0L;
        boolean canceled = false;
        boolean fixedDelay = true;
        Object runParm = null;

        ProxiedTimerTask(TimerParms parms) {
            this.task = parms.task;
            this.period = parms.period;
            this.fixedDelay = parms.fixedDelay;
            this.nextExecutionTime = parms.start;
            this.runParm = parms.runParm;
        }

        public long scheduledExecutionTime() {
            return this.scheduledExecutionTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.canceled = true;
            HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
            synchronized (hMCTaskQueue) {
                HMCTimer.this.queue.notifyAll();
            }
        }

        void run() {
            try {
                this.task.run(this, this.runParm);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(HMCTimer.TRACE_MASKF, "Throwable (" + e + ") from task (" + this.task + ") consumed by " + HMCTimer.this.name + ".");
                Trace.trace(HMCTimer.TRACE_MASKF, e);
            }
        }

        public String toString() {
            return "TimerProxy[" + this.nextExecutionTime + "," + this.period + "," + this.fixedDelay + "," + this.task + "]";
        }

        long reschedule(long currentTime) {
            if (this.fixedDelay) {
                return currentTime + this.period;
            }
            return this.nextExecutionTime + this.period;
        }

        void timeChanged(TimeChangedOnConsoleEvent event) {
        }
    }
}

